
#define _WIN32_WINNT 0x400
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>

#include <string>
#include <vector>
#include <list>
#include <time.h>
#include <algorithm>
#include <fstream>
#include <io.h>
#include <map>

using std::list;
using std::vector;
using std::string;

#include "mesh.h"
#include "D3DApp.h"
#include "common_globals.h"

#include "EffectLayout.h"

#include "shader.h"

#include "deferred.h"

#include "effect.h"
#include "EffectPixParticles.h"
#include "EffectCamera.h"



static float quadVerts[3*6] =
{
  1.0f, 1.0f,0.0f,
 -1.0f,-1.0f,0.0f,
 -1.0f, 1.0f,0.0f,
 -1.0f,-1.0f,0.0f,
  1.0f, 1.0f,0.0f,
  1.0f,-1.0f,0.0f
};

const DWORD VertexFVF = (D3DFVF_XYZ);


float *pQV = NULL;

IDirect3DVertexBuffer9 *pBigSquareVB[1000];

struct LVertex
{
    FLOAT    x, y, z;
};


int primsPerBuffer = 4096;

void DrawPrim(float *pVerts, int num) {

  g_D3DApp->m_pd3dDevice->SetFVF(VertexFVF);
  int buffers = num/primsPerBuffer;

  for (int i=0; i<buffers; i++) {
    int numInBuffer = primsPerBuffer;
    if (i==buffers-1) {
      numInBuffer = num-buffers*primsPerBuffer;
    }
    g_D3DApp->m_pd3dDevice->SetStreamSource(0, pBigSquareVB[i], 0, sizeof(LVertex));
    g_D3DApp->m_pd3dDevice->DrawPrimitive(D3DPT_TRIANGLELIST, 0 , numInBuffer*2);
  }


 // g_D3DApp->m_pd3dDevice->DrawPrimitiveUP(D3DPT_TRIANGLELIST,num*2,pVerts,3*sizeof(float));
}

// 

#define MAX_PIX_PARTS 1000000


void EffectPixParticles::Init() {
  m_shader = new Shader();
  m_shader->CreateFromFile("shaders/pix_particle.fx");

  for (int ii=0; ii<1000; ii++) {
    g_D3DApp->m_pd3dDevice->CreateVertexBuffer( primsPerBuffer*6*sizeof(LVertex), 0, VertexFVF, D3DPOOL_DEFAULT, &pBigSquareVB[ii], NULL );
    LVertex *v;
    pBigSquareVB[ii]->Lock( 0, 0, (void**)&v, 0 );
    for (int i=0; i<primsPerBuffer; i++) {
      int ip=i*6;
      v[ip+0].x  = -1.0f;  v[ip+0].y  = -1.0;   v[ip+0].z  = i;
      v[ip+1].x  = -1.0f;  v[ip+1].y  = 1.0f;   v[ip+1].z  = i;
      v[ip+2].x  = 1.0f;   v[ip+2].y  = 1.0f;   v[ip+2].z  = i;
      v[ip+3].x  = -1.0f;  v[ip+3].y  = -1.0f;  v[ip+3].z = i;
      v[ip+4].x  = 1.0f;   v[ip+4].y  = 1.0f;  v[ip+4].z = i;
      v[ip+5].x  = 1.0f;   v[ip+5].y  = -1.0f;  v[ip+5].z = i;
    }
    pBigSquareVB[ii]->Unlock();
  }


/*
  if (pQV == NULL) {
    pQV = new float[3*6*MAX_PIX_PARTS];
    for (int i=0; i<MAX_PIX_PARTS; i++) {
      int ip = i*3*6;
      for (int ii=0; ii<3*6; ii++) {
        int iip = ii+ip;
        pQV[iip] = quadVerts[ii];
      }
      pQV[ip+2] = i;
      pQV[ip+5] = i;
      pQV[ip+8] = i;
      pQV[ip+11] = i;
      pQV[ip+14] = i;
      pQV[ip+17] = i;
    }
  }
*/
}

EffectPixParticles::EffectPixParticles() {
  m_timelineType = render;

  for (int i=0; i<1000; i++) {
    pBigSquareVB[i] = NULL;
  }
}

EffectPixParticles::~EffectPixParticles() {
 // if (pQV != NULL) {
 //   delete pQV;
 // }
  for (int i=0; i<1000; i++) {
    if (pBigSquareVB[i]) {
      pBigSquareVB[i]->Release();
    }
  }
}

void EffectPixParticles::ReloadShaders() {
  delete m_shader;
  Init();
}


void EffectPixParticles::Advance() {
}


int EffectPixParticles::Render() {


  LPDIRECT3DDEVICE9 pd3dDevice = g_D3DApp->m_pd3dDevice;


  pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_CCW); 
  pd3dDevice->SetRenderState(D3DRS_LIGHTING, false);
  pd3dDevice->LightEnable(0, false);
  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);

  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_CURRENT);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXCOORDINDEX, 0);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLOROP, D3DTOP_MODULATE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_SELECTARG1);
  pd3dDevice->SetTextureStageState(0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE);
  pd3dDevice->SetTextureStageState(0, D3DTSS_COLORARG0, D3DTA_CURRENT);
 
  pd3dDevice->SetRenderState(D3DRS_TEXTUREFACTOR, 0xFFFFFFFF);

  pd3dDevice->SetSamplerState( 0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState( 0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR );
  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSU, D3DTADDRESS_WRAP);
  pd3dDevice->SetSamplerState(0, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP);


  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAOP, D3DTOP_BLENDDIFFUSEALPHA);
  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
  pd3dDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);

  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_ONE);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ZERO);



  pd3dDevice->SetRenderState(D3DRS_ZENABLE, true);
  pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, false);
  pd3dDevice->SetRenderState(D3DRS_ZFUNC, D3DCMP_LESSEQUAL);



  HRESULT hr = pd3dDevice->BeginScene();

  if (FAILED(hr)) {
    return hr;
  }

  bool deferredParticles = (GetPR()->getFloat("deferred") > 0.5f); 


  if (deferredParticles) {
    if (GetClearFlags()) {
      GetDeferred()->BeginDraw(true);
    } else {
      GetDeferred()->BeginDraw(false);
    }
    pd3dDevice->SetRenderState(D3DRS_ZWRITEENABLE, true);

  }


  D3DXMATRIXA16 matView;
  D3DXMATRIXA16 matWorld;
  D3DXMATRIXA16 matProj;
  D3DXMATRIXA16 wvp;
  D3DXMATRIXA16 tempMatrix;
  D3DXVECTOR3 vEyePt;
  D3DXVECTOR3 vLookatPt;
  D3DXVECTOR3 vUpVec;

  D3DXMatrixPerspectiveFovLH(&matProj,  GetGlobalCameraFOV(), g_D3DApp->m_aspectRatio, 1.00f, 10000.0f);
  pd3dDevice->SetTransform(D3DTS_PROJECTION, &matProj);

  matView = *GetGlobalCameraView();
  pd3dDevice->SetTransform(D3DTS_VIEW, &matView);

  D3DXMATRIXA16 matViewBill = matView;

  matViewBill._11 = 1.0f;
  matViewBill._12 = 0.0f;
  matViewBill._13 = 0.0f;

  matViewBill._21 = 0.0f;
  matViewBill._22 = 1.0f;
  matViewBill._23 = 0.0f;

  matViewBill._31 = 0.0f;
  matViewBill._32 = 0.0f;
  matViewBill._33 = 1.0f;

  float def_height;
  float def_bumpness;

  Texture *tex;
  Texture *height;

  Texture *pTexInput;

  float g_depthClipMul;

  int bGlobalTexChange = 0;

  D3DXVECTOR3 inputRes;

  D3DXVECTOR4 color = D3DXVECTOR4(1.0f, 1.0f, 1.0f, 1.0f);
  float diffuse = 1.0f;
  float specular = 1.0f;
  float ambience = 0.1f;
  float gSize = 1.0f;

  int num = GetPR()->getN("pixpart");
  for (int i=0; i<num; i++) {
    const EffectParam *p;
    p = GetPR()->get("pixpart", i);
    if (p->hide == 1)
      continue;

    def_height = p->getFloat("def_height");
    def_bumpness = p->getFloat("def_bumpness");

    tex = g_D3DApp->addTexture(p->getString("image").c_str());
    height = g_D3DApp->addTexture(p->getString("height").c_str());

    // std::string kuukkos = "kuukkos123";
    std::string kuukkos = p->getString("input");

    Texture *pTex = g_D3DApp->getTexture(kuukkos.c_str());
    if (!pTex) {
      pTexInput = g_D3DApp->createRenderTarget(g_D3DApp->m_windowWidth, g_D3DApp->m_windowHeight, kuukkos.c_str(), 1, D3DFMT_A32B32G32R32F);
    } else {
      pTexInput = pTex;
    }
   
    inputRes = p->getVec3("input_res");

    color = p->getVec4("color");
    diffuse = p->getFloat("diffuse");
    specular = p->getFloat("specular");
    ambience = p->getFloat("ambience");
    gSize = p->getFloat("size");

    g_depthClipMul = p->getFloat("depth_clip_mul");
  }

   

  D3DXVECTOR3 globalPos = GetPR()->getVec3("global_position");
  if (deferredParticles) {
    m_shader->Enable("RenderDeferred");
  } else {
    m_shader->Enable("Render");
  }
  D3DXVECTOR3 globalForce = GetPR()->getVec3("force");


  D3DXVECTOR4 texCoordScale = D3DXVECTOR4(1.0f, 1.0f, 1.0f, 1.0f);
  D3DXVECTOR4 texCoordOfs = D3DXVECTOR4(0.0f, 0.0f, 0.0f, 0.0f);

  m_shader->GetEffect()->SetVector( "g_texCoordScale", &texCoordScale);
  m_shader->GetEffect()->SetVector( "g_texCoordOfs", &texCoordOfs);

  m_shader->GetEffect()->SetFloat( "g_windowWidth", g_D3DApp->m_windowWidth);
  m_shader->GetEffect()->SetFloat( "g_windowHeight", g_D3DApp->m_windowHeight);


  Texture *particleTexture = NULL;
  Texture *particleHeightTexture = NULL;

  particleTexture = tex;
  particleHeightTexture = height;

  g_D3DApp->setTexture(particleTexture);
  if (deferredParticles) {
    g_D3DApp->setTexture(particleHeightTexture, 1);
    m_shader->GetEffect()->SetFloat("g_defHeight", def_height);
    m_shader->GetEffect()->SetFloat("g_defBumpness", def_bumpness);
  }

  m_shader->GetEffect()->SetFloat("g_time", m_effectTime);

  m_shader->GetEffect()->SetTexture("g_texPartPos", pTexInput->lpTexture);
 // g_D3DApp->setTexture(pTexInput,2);

  pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, true);
/*
  if (m_particles.front().m_blendMode == "add") {
    pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
    pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE);
  } else {
  */
  pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
  pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
//   }

  if (deferredParticles) {
    pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, false);
  }

  m_shader->GetEffect()->SetMatrix( "g_mView", &matView );

  D3DXVECTOR3 trans = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
  D3DXVECTOR3 rot = D3DXVECTOR3(0.0f, 0.0f, 0.0f);
  D3DXVECTOR3 scale = D3DXVECTOR3(1.0f, 1.0f, 1.0f);

  g_D3DApp->MakeWorldMatrix(&matWorld, &trans, &scale, &rot);

  pd3dDevice->SetTransform(D3DTS_WORLD, &matWorld);

  D3DXMATRIXA16 matWVP = matWorld*matViewBill*matProj;


  if (deferredParticles) {
    m_shader->GetEffect()->SetMatrix( "g_mWorld", &matWorld );
    m_shader->GetEffect()->SetMatrix( "g_mView", &matView );
    m_shader->GetEffect()->SetMatrix( "g_mViewBill", &matViewBill );
    m_shader->GetEffect()->SetMatrix( "g_mProj", &matProj );
  }
  m_shader->GetEffect()->SetMatrix( "g_mWorldViewProjection", &matWVP );
  m_shader->GetEffect()->SetFloat( "g_depthClipMul", g_depthClipMul );
  m_shader->GetEffect()->SetVector( "g_color", &color);
  m_shader->GetEffect()->SetFloat("g_diffuse", diffuse);
  m_shader->GetEffect()->SetFloat("g_specular", specular);
  m_shader->GetEffect()->SetFloat("g_ambience", ambience);
  m_shader->GetEffect()->SetFloat("g_size", gSize);




 // g_D3DApp->setTexture(pTexInput,2);
 // m_shader->GetEffect()->SetTexture("g_texPartPos", pTexInput->lpTexture);


  int numParts = inputRes.x * inputRes.y;

//  for (int i=0; i<numParts; i++) {
//    DrawPrim(pQV, numParts);

  g_D3DApp->m_pd3dDevice->SetFVF(VertexFVF);
  int buffers = numParts/primsPerBuffer;

  for (int i=0; i<buffers; i++) {

    m_shader->GetEffect()->SetFloat("g_particleIndexOffset", i*primsPerBuffer);
    m_shader->Flush();

    int numInBuffer = primsPerBuffer;
    if (i==buffers-1) {
      numInBuffer = num-buffers*primsPerBuffer;
    }
    g_D3DApp->m_pd3dDevice->SetStreamSource(0, pBigSquareVB[i], 0, sizeof(LVertex));
    g_D3DApp->m_pd3dDevice->DrawPrimitive(D3DPT_TRIANGLELIST, 0 , numInBuffer*2);
  }


//  }
  //g_D3DApp->drawSquare(1.0f);

  m_shader->Disable();

  if (deferredParticles) {
    GetDeferred()->EndDraw();
  }

  // End the scene.
  pd3dDevice->EndScene();


  return true;
}
